﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using Autodesk.Max;
using Autodesk.Max.Plugins;

namespace MaxDotNetExport
{
    public class Hwnd32 : IWin32Window
    {
        private IntPtr m_hwnd;

        public Hwnd32(IntPtr handle)
        {
            m_hwnd = handle;
        }

        public IntPtr Handle
        {
            get { return m_hwnd; }
        }
    }

    public class ExporterDescriptor : ClassDesc2
    {
        private IGlobal m_global;
        private static IClass_ID s_classID;

        public ExporterDescriptor(IGlobal global)
        {
            m_global = global;
            s_classID = global.Class_ID.Create(8264, 9283472);
        }

        public override string Category
        {
            get { return "Max.NET Exporter"; }
        }

        public override IClass_ID ClassID
        {
            get { return s_classID; }
        }

        public override string ClassName
        {
            get { return "MaxDotNet Exporter"; }
        }

        public override object Create(bool loading)
        {
            return new DotNetExport(m_global);
        }

        public override bool IsPublic
        {
            get { return true; }
        }

        public override SClass_ID SuperClassID
        {
            get { return SClass_ID.SceneExport; }
        }
    }

    public class DotNetExport : SceneExport
    {
        private IGlobal m_global;
        
        public DotNetExport(IGlobal global)
            {
                m_global = global;
            }

        public override string Ext(int n)
          {
              return "Ext";
          }
          public override int ExtCount
          {
              get { return 1; }
          }

          public void print(string themsg)
          {
              IGlobal MaxGlobal = m_global;
              IInterface MaxInterface = MaxGlobal.COREInterface;
              MaxGlobal.TheListener.EditStream.Printf("sssssssss" + string.Empty, null);
          }
        public override int DoExport( string name,IExpInterface exportInterface,IInterface maxInterface,bool suppressPrompts ,uint option)
        {
            MessageBox.Show("Do Export");

            IGlobal MaxGlobal = m_global;           
            IInterface MaxInterface = MaxGlobal.COREInterface;

            MaxGlobal.TheListener.EditStream.Printf("sssssssss" + string.Empty, null);
            MaxGlobal.TheListener.MacrorecStream.Printf("ffffffffffff" + string.Empty, null);

            IIGameScene gameScene = MaxGlobal.IGameInterface;
            MessageBox.Show( MaxGlobal.IGameInterface.SceneFileName);
            gameScene.InitialiseIGame(false);

            int NodeCount = MaxGlobal.IGameInterface.TopLevelNodeCount;
            MessageBox.Show(NodeCount.ToString());
            for (int i = 0 ;i < NodeCount;i++)
            {
                IIGameNode tNode = MaxGlobal.IGameInterface.GetTopLevelNode(i);
                MessageBox.Show(tNode.Name);
            }

            MessageBox.Show(gameScene.TotalNodeCount.ToString());
            MessageBox.Show("Do Export Over");
            return 1;
        }

        public override void ShowAbout(IntPtr hWnd)
        {

        }

        public override uint Version
        {
            get { return 1; }
        }

        public override string OtherMessage1()
        {
            return "OtherMessage1()";
        }

        public override string OtherMessage2()
        {
            return "OtherMessage2()";
        }

        public override string CopyrightMessage
        {
            get { return "CopyrightMessage"; }
        }

        public override string AuthorName
        {
            get { return "AuthorName"; }
        }

        public override string LongDesc
        {
            get { return "LongDesc"; }
        }

        public override string ShortDesc
        {
            get { return "ShortDesc"; }
        }
    }
}
