﻿using System;
using System.Collections.Generic;
using System.Text;
using Autodesk.Max;
using Autodesk.Max.Plugins;
using System.Windows.Forms;

namespace Test
{
    public class Test : IPlugin
    {
        IIMenu menu = null;
        IIMenuItem menuItem = null;
        IIMenuItem menuItemMyAction = null;
        uint idActionTable = 0;
        IActionTable actionTable = null;
        IActionCallback actionCallback = null;

        public IGlobal global;


        public void Cleanup()
        {
            MenusAndActionsUnregister();
        }

        public void Initialize(IGlobal global, System.ComponentModel.ISynchronizeInvoke sync)
        {
            this.global = global;
            MenusAndActionsRegister();
           
        }


        void MenusAndActionsRegister()
        {
            IIActionManager actionManager = global.COREInterface.ActionManager;
            IIMenuManager menuManager = global.COREInterface.MenuManager;

            IActionTable actionTable = null;
            // Set up global actions
            {
                idActionTable = (uint)actionManager.NumActionTables;

                string actionTableName = "Test Action" + " Actions";
                actionTable = global.ActionTable.Create(idActionTable, 0, ref actionTableName);
                TestAction theAction = new TestAction();
                actionTable.AppendOperation(theAction);
            }
            // Set up menu
            {
                this.menu = menuManager.FindMenu("Test Action");

                if (this.menu != null)
                {
                    menuManager.UnRegisterMenu(menu);
                    global.ReleaseIMenu(menu);
                    this.menu = null;
                }

                this.menuItem = global.IMenuItem;
                this.menuItem.Title = "Test Action";
                // Main menu
                {
                    this.menu = global.IMenu;
                    this.menu.Title = "Test Action";
                    menuManager.RegisterMenu(menu, 0);

                    // Launch option
                    {
                        this.menuItemMyAction = global.IMenuItem;
                        this.menuItemMyAction.Title = "&Test Action";
                        this.menuItemMyAction.ActionItem = actionTable[0];
                        menu.AddItem(this.menuItemMyAction, -1);
                    }
                }
                this.menuItem.SubMenu = menu;

                menuManager.MainMenuBar.AddItem(this.menuItem, -1);

                global.COREInterface.MenuManager.UpdateMenuBar();
                MessageBox.Show("MenusAndActionsRegister");
            }
        }

        void MenusAndActionsUnregister()
        {
            if (this.actionTable != null)
            {
                global.COREInterface.ActionManager.DeactivateActionTable(actionCallback, idActionTable);
            }

            // Clean up menu
            if (this.menu != null)
            {
                global.COREInterface.MenuManager.UnRegisterMenu(menu);
                global.ReleaseIMenu(menu);
                global.ReleaseIMenuItem(menuItemMyAction);
                global.ReleaseIMenuItem(menuItem);

                this.menu = null;
                this.menuItem = null;
            }
        }
      
    }
}
