﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Autodesk.Max;
using Autodesk.Max.Plugins;


namespace Test
{
     class TestAction : ActionItem
    {
        const string ActionName = "Test Action";

        public TestAction()
        {
            MessageBox.Show("TestAction");
            ExecuteAction();
        }

        public override string ButtonText
        {
            get { return ActionName; }
        }

        public override string CategoryText
        {
            get { return ActionName; }
        }

        public override string DescriptionText
        {
            get { return ActionName + " " + ActionName; }
        }

        public override bool ExecuteAction()
        {
            MessageBox.Show("ExecuteAction");
            return false;
        }

         /*
        public override bool Execute()
        {
            MessageBox.Show("ok Execute");
            
            return true;
        }
         */

        public override IMaxIcon Icon
        {
            get { return null; }
        }

        public override int Id
        {
            get { return 1; }
        }

        public override bool IsChecked
        {
            get { return false; }
        }

        public override bool IsEnabled
        {
            get { return true; }
        }

        public override bool IsItemVisible
        {
            get { return true; }
        }

        public override string MenuText
        {
            get { return "&" + ActionName + "..."; }
        }
    }

}
