﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Autodesk.Max;

namespace Test
{
    public partial class TestForm : Form
	{
		IGlobal global;
        public TestForm(IGlobal global)
		{
			this.global = global;
			InitializeComponent();
		}

		private void button1_Click( object sender, EventArgs e )
		{
			IInterface iface = global.COREInterface;
			IInterval interval = global.Interval.Create();

			IShapeObject shapeObject = null;
			IMatrix3 shapeObjectTM = null;
			for( int i = 0; i < iface.SelNodeCount; ++i )
			{
				IINode node = iface.GetSelNode( i );
				if( node.ObjectRef.SuperClassID == SClass_ID.Shape )
				{
					shapeObject = node.ObjectRef as IShapeObject;
					shapeObjectTM = node.GetObjectTM( 0, interval );
					break;
				}
			}

			if( shapeObject == null )
			{
				MessageBox.Show( "No shape present in selection" );
				return;
			}

			for( int i = 0; i < iface.SelNodeCount; ++i )
			{
				IINode node = iface.GetSelNode( i );
				if( !node.ObjectRef.Equals( shapeObject as IInterfaceServer ) )
				{
					float f = (float)i / ( (float)iface.SelNodeCount - 1 );
					IPoint3 pointOnShape = shapeObject.InterpCurve3D( 0, 0, f, 0 );

					interval.SetInfinite();
					IMatrix3 nodeTM = node.GetObjectTM( 0, interval );
					nodeTM.Trans = shapeObjectTM.PointTransform( pointOnShape );
					node.SetNodeTM( 0, nodeTM );
				}
			}
            
			iface.ForceCompleteRedraw( false );
		}

        private void BtnPosToZero_Click(object sender, EventArgs e)
        {
            IInterface iface = global.COREInterface;
            IInterval interval = global.Interval.Create();

            for (int i = 0; i < iface.SelNodeCount; ++i)
            {
                IINode node = iface.GetSelNode(i);
                
                interval.SetInfinite();
                IMatrix3 nodeTM = node.GetObjectTM(0, interval);
                node.SetNodeTM(0, nodeTM);

                IMatrix3 ZeroMatrix3 = global.Matrix3.Create();
                ZeroMatrix3.SetScale(global.Point3.Create(new float[3] { 1, 1, 1 }));
                node.SetNodeTM(0,ZeroMatrix3);
            }
            IINode theTeapot = iface.GetINodeByName("teapot*");
            
            iface.SelectNode(theTeapot, true);
            
            iface.ForceCompleteRedraw(false);
        }

        private void BtnExit_Click(object sender, EventArgs e)
        {
            IInterface iface = global.COREInterface;
            IInterval interval = global.Interval.Create();
            

        }
	}
}

